/*
 * Decompiled with CFR 0.152.
 */
package tech.scolton.iiqdaij.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tech.scolton.iiqdaij.client.Target;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002\",\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"validTargets", "", "Lcom/intellij/openapi/project/Project;", "", "Ltech/scolton/iiqdaij/client/Target;", "getValidTargets", "()Ljava/util/Map;", "setValidTargets", "(Ljava/util/Map;)V", "updateValidTargets", "", "project", "IIQDA-IJ"})
public final class TargetsKt {
    @NotNull
    private static Map<Project, List<Target>> validTargets = new LinkedHashMap();

    @NotNull
    public static final Map<Project, List<Target>> getValidTargets() {
        return validTargets;
    }

    public static final void setValidTargets(@NotNull Map<Project, List<Target>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        validTargets = map;
    }

    /*
     * WARNING - void declaration
     */
    public static final void updateValidTargets(@NotNull Project project) {
        Module[] modules;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"getInstance(project).modules");
        Module[] $this$associateWith$iv = modules = moduleArray;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateWith$iv.length), (int)16));
        Module[] $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        Module[] moduleArray2 = $this$associateWithTo$iv$iv;
        int n = moduleArray2.length;
        for (int i = 0; i < n; ++i) {
            void it;
            Module element$iv$iv;
            Module module = element$iv$iv = moduleArray2[i];
            Module module2 = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)it).getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getInstance(it).contentRoots");
            List list = ArraysKt.toList((Object[])virtualFileArray);
            map.put(module2, list);
        }
        Map modulesToRoots = result$iv;
        List targets = new ArrayList();
        for (Map.Entry entry : modulesToRoots.entrySet()) {
            List roots = (List)entry.getValue();
            Module module = (Module)entry.getKey();
            for (VirtualFile root : roots) {
                VirtualFile[] children = root.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)children, (String)"children");
                for (VirtualFile child : children) {
                    String password;
                    String username;
                    String baseUrl;
                    String namePrefix;
                    String string = child.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"child.name");
                    if (!StringsKt.endsWith$default((String)string, (String)".target.properties", (boolean)false, (int)2, null)) continue;
                    InputStreamReader reader = new InputStreamReader(child.getInputStream());
                    Properties props = new Properties();
                    props.load(reader);
                    String string2 = namePrefix = modules.length > 1 ? module.getName() + " : " : "";
                    if (props.getProperty("%%ECLIPSE_USER%%") == null || props.getProperty("%%ECLIPSE_PASS%%") == null || props.getProperty("%%ECLIPSE_URL%%") == null) continue;
                    String string3 = props.getProperty("%%TARGET%%");
                    if (string3 == null) {
                        string3 = baseUrl;
                    }
                    String name = namePrefix + string3;
                    targets.add(new Target(name, baseUrl, username, password, props));
                }
            }
        }
        validTargets.put(project, CollectionsKt.toList((Iterable)targets));
    }
}

