/*
 * Decompiled with CFR 0.152.
 */
package tech.scolton.iiqdaij.actions;

import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.InputStream;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tech.scolton.iiqdaij.client.IIQClient;
import tech.scolton.iiqdaij.client.Target;
import tech.scolton.iiqdaij.dialog.ConfirmationDialogWrapper;
import tech.scolton.iiqdaij.util.SubstitutionStream;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ltech/scolton/iiqdaij/actions/DeployAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "target", "Ltech/scolton/iiqdaij/client/Target;", "(Ltech/scolton/iiqdaij/client/Target;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "IIQDA-IJ"})
public final class DeployAction
extends AnAction {
    @NotNull
    private final Target target;

    public DeployAction(@NotNull Target target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.target = target;
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("IIQDA Notifications");
        try {
            void title$iv;
            String string = "Deploy to " + this.target.getName();
            Project project$iv = e.getProject();
            boolean cancellable$iv = true;
            boolean $i$f$runBackgroundableTask = false;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project$iv, (String)title$iv, cancellable$iv, project$iv, (String)title$iv, cancellable$iv, e, this, notificationGroup){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $title;
                final /* synthetic */ boolean $cancellable;
                final /* synthetic */ AnActionEvent $e$inlined;
                final /* synthetic */ DeployAction this$0;
                final /* synthetic */ NotificationGroup $notificationGroup$inlined;
                {
                    this.$project = $captured_local_variable$1;
                    this.$title = $captured_local_variable$2;
                    this.$cancellable = $captured_local_variable$3;
                    this.$e$inlined = anActionEvent;
                    this.this$0 = deployAction;
                    this.$notificationGroup$inlined = notificationGroup;
                    super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ProgressIndicator it = indicator;
                    boolean bl = false;
                    it.setIndeterminate(true);
                    it.setText("Deploying...");
                    VirtualFile virtualFile = (VirtualFile)this.$e$inlined.getData(CommonDataKeys.VIRTUAL_FILE);
                    if (virtualFile != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"e.getData(CommonDataKeys\u2026urn@runBackgroundableTask");
                        VirtualFile file = virtualFile;
                        it.setText("Deploying " + file.getName() + " to " + DeployAction.access$getTarget$p(this.this$0).getName() + "...");
                        Properties properties = DeployAction.access$getTarget$p(this.this$0).getSubs();
                        InputStream inputStream = file.getInputStream();
                        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"file.inputStream");
                        SubstitutionStream fileStream = new SubstitutionStream(properties, inputStream);
                        String fileContents = new String(fileStream.readAllBytes(), Charsets.UTF_8);
                        if (!fileStream.hasWarnings() || new ConfirmationDialogWrapper(fileStream.getWarnings(), DeployAction.access$getTarget$p(this.this$0).getName()).showAndGet()) {
                            IIQClient client = new IIQClient(DeployAction.access$getTarget$p(this.this$0));
                            try {
                                client.deploy(fileContents);
                                this.$notificationGroup$inlined.createNotification("Successfully deployed " + file.getName() + " to " + DeployAction.access$getTarget$p(this.this$0).getName() + ".", NotificationType.INFORMATION).notify(this.$e$inlined.getProject());
                                it.setFraction(1.0);
                            }
                            catch (Exception ex) {
                                this.$notificationGroup$inlined.createNotification("Failed to deploy: " + ex.getMessage(), NotificationType.ERROR).notify(this.$e$inlined.getProject());
                            }
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            notificationGroup.createNotification("An error occurred: " + ex.getMessage(), NotificationType.ERROR).notify(e.getProject());
            return;
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getProject() == null) {
            return;
        }
        VirtualFile virtualFile = (VirtualFile)e.getData(PlatformDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file = virtualFile;
        e.getPresentation().setText(this.target.getName());
        e.getPresentation().setIcon(AllIcons.Actions.Lightning);
        Presentation presentation = e.getPresentation();
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        presentation.setEnabledAndVisible(StringsKt.endsWith((String)string, (String)".xml", (boolean)true));
    }

    public static final /* synthetic */ Target access$getTarget$p(DeployAction $this) {
        return $this.target;
    }
}

