/*
 * Decompiled with CFR 0.152.
 */
package tech.scolton.iiqdaij.actions;

import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import tech.scolton.iiqdaij.client.IIQClient;
import tech.scolton.iiqdaij.client.Target;
import tech.scolton.iiqdaij.dialog.ConfirmationDialogWrapper;
import tech.scolton.iiqdaij.util.SubstitutionStream;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ltech/scolton/iiqdaij/actions/DeployAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "target", "Ltech/scolton/iiqdaij/client/Target;", "(Ltech/scolton/iiqdaij/client/Target;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "IIQDA-IJ"})
public final class DeployAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Target target;

    public DeployAction(@NotNull Target target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.target = target;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        NotificationGroupManager notificationGroupManager = NotificationGroupManager.getInstance();
        NotificationGroup successNotificationGroup = notificationGroupManager.getNotificationGroup("IIQDA Notifications");
        NotificationGroup errorNotificationGroup = notificationGroupManager.getNotificationGroup("IIQDA Sticky Notifications");
        Project project = e.getProject();
        try {
            String title$iv = "Deploy to " + this.target.getName();
            boolean cancellable$iv = true;
            boolean $i$f$runBackgroundableTask = false;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title$iv, cancellable$iv, project, title$iv, cancellable$iv, e, this, successNotificationGroup, errorNotificationGroup, project){
                final /* synthetic */ Project $project;
                final /* synthetic */ String $title;
                final /* synthetic */ boolean $cancellable;
                final /* synthetic */ AnActionEvent $e$inlined;
                final /* synthetic */ DeployAction this$0;
                final /* synthetic */ NotificationGroup $successNotificationGroup$inlined;
                final /* synthetic */ NotificationGroup $errorNotificationGroup$inlined;
                final /* synthetic */ Project $project$inlined;
                {
                    this.$project = $captured_local_variable$1;
                    this.$title = $captured_local_variable$2;
                    this.$cancellable = $captured_local_variable$3;
                    this.$e$inlined = anActionEvent;
                    this.this$0 = deployAction;
                    this.$successNotificationGroup$inlined = notificationGroup;
                    this.$errorNotificationGroup$inlined = notificationGroup2;
                    this.$project$inlined = project;
                    super($super_call_param$4, $super_call_param$5, $super_call_param$6);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    block15: {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        ProgressIndicator it = indicator;
                        boolean bl = false;
                        it.setIndeterminate(true);
                        it.setText("Deploying...");
                        List<VirtualFile> files = DeployAction.Companion.relevantVirtualFiles(this.$e$inlined);
                        if (files.isEmpty()) {
                            it.setFraction(1.0);
                        } else {
                            String content;
                            Object object;
                            double done = 0.0;
                            List failures = new ArrayList<E>();
                            List successes = new ArrayList<E>();
                            String firstErrorDetails = null;
                            for (VirtualFile file : files) {
                                block16: {
                                    if (it.isCanceled()) break;
                                    it.setText("Deploying " + file.getName() + " to " + DeployAction.access$getTarget$p(this.this$0).getName() + "...");
                                    Properties properties = DeployAction.access$getTarget$p(this.this$0).getSubs();
                                    InputStream inputStream = file.getInputStream();
                                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"file.inputStream");
                                    SubstitutionStream fileStream = new SubstitutionStream(properties, inputStream);
                                    String fileContents = new String(fileStream.readAllBytes(), Charsets.UTF_8);
                                    if (fileStream.hasWarnings() && !new ConfirmationDialogWrapper(fileStream.getWarnings(), DeployAction.access$getTarget$p(this.this$0).getName()).showAndGet()) break block15;
                                    IIQClient client = new IIQClient(DeployAction.access$getTarget$p(this.this$0));
                                    try {
                                        client.deploy(fileContents);
                                        String string = file.getName();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                                        successes.add(string);
                                    }
                                    catch (Exception ex) {
                                        String string = file.getName();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                                        failures.add(string);
                                        if (firstErrorDetails != null) break block16;
                                        firstErrorDetails = ex.getMessage();
                                    }
                                }
                                it.setFraction((done += 1.0) / (double)files.size());
                            }
                            it.setFraction(1.0);
                            String successList = CollectionsKt.joinToString$default((Iterable)successes, null, null, null, (int)0, null, null, (int)63, null);
                            String failureList = CollectionsKt.joinToString$default((Iterable)failures, null, null, null, (int)0, null, null, (int)63, null);
                            switch (failures.size()) {
                                case 0: {
                                    object = "";
                                    break;
                                }
                                case 1: {
                                    object = "Error details: " + firstErrorDetails;
                                    break;
                                }
                                default: {
                                    object = "First error details (" + failures.get(0) + "): " + firstErrorDetails;
                                }
                            }
                            Object errorText = object;
                            NotificationType notificationType = null;
                            String title = null;
                            String string = failures.size() == 0 ? "Successfully deployed all artifacts:\n\n" + successList : (content = failures.size() < files.size() ? "Successfully deployed the following artifacts: " + successList + "<br><br>Failed to deploy the following artifacts: " + failureList + "<br><br>" + (String)errorText : "Failed to deploy all artifacts:<br><br>" + failureList + "<br><br>" + (String)errorText);
                            if (it.isCanceled() && successes.size() + failures.size() != files.size()) {
                                content = "Deployment was cancelled before completion. Partial results:<br><br>" + content;
                                title = "Deployment incomplete";
                                notificationType = failures.size() != files.size() ? NotificationType.WARNING : NotificationType.ERROR;
                            } else if (failures.size() == 0) {
                                title = "Deployment succeeded";
                                notificationType = NotificationType.INFORMATION;
                            } else if (failures.size() < files.size()) {
                                title = "Deployment completed with warnings";
                                notificationType = NotificationType.WARNING;
                            } else {
                                title = "Deployment failed";
                                notificationType = NotificationType.ERROR;
                            }
                            NotificationGroup notificationGroup = WhenMappings.$EnumSwitchMapping$0[notificationType.ordinal()] == 1 ? this.$successNotificationGroup$inlined : this.$errorNotificationGroup$inlined;
                            Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"notificationGroup");
                            NotificationGroup.createNotification$default((NotificationGroup)notificationGroup, (String)title, (String)content, (NotificationType)notificationType, null, (int)8, null).notify(this.$project$inlined);
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            errorNotificationGroup.createNotification("An error occurred: " + ex.getMessage(), NotificationType.ERROR).notify(e.getProject());
            return;
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getProject() == null) {
            return;
        }
        e.getPresentation().setText(this.target.getName());
        e.getPresentation().setIcon(AllIcons.Actions.Lightning);
        e.getPresentation().setEnabledAndVisible(Companion.isOrContainsRelevantFile(e));
    }

    public static final /* synthetic */ Target access$getTarget$p(DeployAction $this) {
        return $this.target;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\n"}, d2={"Ltech/scolton/iiqdaij/actions/DeployAction$Companion;", "", "()V", "isOrContainsRelevantFile", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "relevantVirtualFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "IIQDA-IJ"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<VirtualFile> relevantVirtualFiles(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(PlatformDataKeys.VIRTUAL_FILE_ARRAY);
            if (virtualFileArray == null) {
                return CollectionsKt.emptyList();
            }
            VirtualFile[] files = virtualFileArray;
            LinkedHashSet allFiles = new LinkedHashSet();
            for (VirtualFile file : files) {
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                allFiles.addAll(tech.scolton.iiqdaij.actions.DeployAction$Companion.relevantVirtualFiles$getFilesInternal(file));
            }
            return CollectionsKt.toList((Iterable)allFiles);
        }

        public final boolean isOrContainsRelevantFile(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(PlatformDataKeys.VIRTUAL_FILE_ARRAY);
            if (virtualFileArray == null) {
                return false;
            }
            for (VirtualFile file : virtualFileArray) {
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                if (!tech.scolton.iiqdaij.actions.DeployAction$Companion.isOrContainsRelevantFile$walkFilesInternal(file)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private static final LinkedHashSet<VirtualFile> relevantVirtualFiles$getFilesInternal(VirtualFile file) {
            LinkedHashSet linkedHashSet;
            if (file.isDirectory()) {
                void var1_1;
                LinkedHashSet children = new LinkedHashSet();
                VirtualFile[] virtualFileArray = file.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"file.children");
                for (VirtualFile child : virtualFileArray) {
                    Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                    children.addAll(tech.scolton.iiqdaij.actions.DeployAction$Companion.relevantVirtualFiles$getFilesInternal(child));
                }
                linkedHashSet = var1_1;
            } else if (StringsKt.equals((String)file.getExtension(), (String)"xml", (boolean)true)) {
                Object[] objectArray = new VirtualFile[]{file};
                linkedHashSet = SetsKt.linkedSetOf((Object[])objectArray);
            } else {
                linkedHashSet = new LinkedHashSet();
            }
            return linkedHashSet;
        }

        private static final boolean isOrContainsRelevantFile$walkFilesInternal(VirtualFile file) {
            if (file.isDirectory()) {
                VirtualFile[] virtualFileArray = file.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"file.children");
                for (VirtualFile child : virtualFileArray) {
                    Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                    boolean childTest = tech.scolton.iiqdaij.actions.DeployAction$Companion.isOrContainsRelevantFile$walkFilesInternal(child);
                    if (!childTest) continue;
                    return true;
                }
                return false;
            }
            return StringsKt.equals((String)file.getExtension(), (String)"xml", (boolean)true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotificationType.values().length];
            nArray[NotificationType.INFORMATION.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

