/*
 * Decompiled with CFR 0.152.
 */
package tech.scolton.iiqdaij.client;

import java.net.URI;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;
import tech.scolton.iiqdaij.client.IIQClient;
import tech.scolton.iiqdaij.client.RESTRequest;
import tech.scolton.iiqdaij.client.RESTResponse;
import tech.scolton.iiqdaij.client.Target;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bJ\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ltech/scolton/iiqdaij/client/IIQClient;", "", "target", "Ltech/scolton/iiqdaij/client/Target;", "(Ltech/scolton/iiqdaij/client/Target;)V", "baseUri", "Ljava/net/URI;", "username", "", "password", "(Ljava/net/URI;Ljava/lang/String;Ljava/lang/String;)V", "json", "Lkotlinx/serialization/json/Json;", "deploy", "", "artifactXml", "getAuthenticatedClient", "Lkotlin/Pair;", "Lorg/apache/http/client/HttpClient;", "Lorg/apache/http/client/protocol/HttpClientContext;", "IIQDA-IJ"})
public final class IIQClient {
    @NotNull
    private final URI baseUri;
    @NotNull
    private final String username;
    @NotNull
    private final String password;
    @NotNull
    private final Json json;

    public IIQClient(@NotNull URI baseUri, @NotNull String username, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)baseUri, (String)"baseUri");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.baseUri = baseUri;
        this.username = username;
        this.password = password;
        this.json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
    }

    public IIQClient(@NotNull Target target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this(new URI(target.getBaseUrl()), target.getUsername(), target.getPassword());
    }

    private final Pair<HttpClient, HttpClientContext> getAuthenticatedClient() {
        BasicCredentialsProvider credentialProvider = new BasicCredentialsProvider();
        HttpHost host = new HttpHost(this.baseUri.getHost(), this.baseUri.getPort(), this.baseUri.getScheme());
        credentialProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme scheme = new BasicScheme();
        authCache.put(host, (AuthScheme)scheme);
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialProvider).build();
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)credentialProvider);
        BasicAuthCache cache = new BasicAuthCache();
        cache.put(host, (AuthScheme)new BasicScheme());
        context.setAuthCache((AuthCache)cache);
        return new Pair((Object)client, (Object)context);
    }

    /*
     * WARNING - void declaration
     */
    public final void deploy(@NotNull String artifactXml) {
        void $this$encodeToString$iv;
        Intrinsics.checkNotNullParameter((Object)artifactXml, (String)"artifactXml");
        URI path = new URI(this.baseUri + "/").resolve("rest/workflows/Importer/launch");
        Pair<HttpClient, HttpClientContext> pair = this.getAuthenticatedClient();
        HttpClient client = (HttpClient)pair.component1();
        HttpClientContext context = (HttpClientContext)pair.component2();
        HttpPost post = new HttpPost(path);
        StringFormat stringFormat = (StringFormat)this.json;
        RESTRequest value$iv = new RESTRequest(new RESTRequest.WorkflowArgs(artifactXml, "Import"));
        boolean $i$f$encodeToString = false;
        Object $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(RESTRequest.class));
        boolean $i$f$cast = false;
        KSerializer kSerializer = $this$cast$iv$iv$iv;
        if (kSerializer == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<T>");
        }
        String body = $this$encodeToString$iv.encodeToString((SerializationStrategy)kSerializer, (Object)value$iv);
        post.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_JSON));
        post.setHeader("accept", "application/json");
        HttpResponse response = client.execute((HttpUriRequest)post, (HttpContext)context);
        HttpEntity httpEntity = response.getEntity();
        if (httpEntity == null) {
            return;
        }
        HttpEntity responseEntity = httpEntity;
        byte[] byArray = responseEntity.getContent().readAllBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"responseEntity.content.readAllBytes()");
        $this$serializer$iv$iv = byArray;
        String responseString = new String((byte[])$this$serializer$iv$iv, Charsets.UTF_8);
        try {
            StringFormat $this$decodeFromString$iv = (StringFormat)this.json;
            boolean $i$f$decodeFromString = false;
            SerializersModule $this$serializer$iv$iv2 = $this$decodeFromString$iv.getSerializersModule();
            boolean $i$f$serializer2 = false;
            KSerializer $this$cast$iv$iv$iv2 = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv2, (KType)Reflection.typeOf(RESTResponse.class));
            boolean $i$f$cast2 = false;
            KSerializer kSerializer2 = $this$cast$iv$iv$iv2;
            if (kSerializer2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<T>");
            }
            RESTResponse responseObject = (RESTResponse)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)kSerializer2, responseString);
            if (Intrinsics.areEqual((Object)responseObject.getAttributes().getResult(), (Object)"success")) {
                return;
            }
            throw new Exception("POST failed " + responseObject.getAttributes().getPayload());
        }
        catch (Exception e) {
            throw new Exception("Error decoding response. Full response: " + responseString);
        }
    }
}

