/*
 * Decompiled with CFR 0.152.
 */
package tech.scolton.iiqdaij.util;

import java.io.FilterInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\b\u0010\u0018\u001a\u00020\u000bH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0016J\u0006\u0010\u001c\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Ltech/scolton/iiqdaij/util/SubstitutionStream;", "Ljava/io/FilterInputStream;", "subs", "Ljava/util/Properties;", "stream", "Ljava/io/InputStream;", "<init>", "(Ljava/util/Properties;Ljava/io/InputStream;)V", "substBuffer", "Ljava/nio/ByteBuffer;", "skipNext", "", "warnings", "", "", "getWarnings", "()Ljava/util/List;", "read", "", "b", "", "off", "len", "available", "markSupported", "close", "", "readAllBytes", "hasWarnings", "IIQDA-IJ"})
public final class SubstitutionStream
extends FilterInputStream {
    @NotNull
    private final Properties subs;
    @NotNull
    private final InputStream stream;
    @Nullable
    private ByteBuffer substBuffer;
    private boolean skipNext;
    @NotNull
    private final List<String> warnings;

    public SubstitutionStream(@NotNull Properties subs, @NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)subs, (String)"subs");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        super(stream);
        this.subs = subs;
        this.stream = stream;
        this.warnings = new ArrayList();
    }

    @NotNull
    public final List<String> getWarnings() {
        return this.warnings;
    }

    @Override
    public int read() {
        if (this.substBuffer != null) {
            ByteBuffer byteBuffer = this.substBuffer;
            Intrinsics.checkNotNull((Object)byteBuffer);
            if (byteBuffer.hasRemaining()) {
                ByteBuffer byteBuffer2 = this.substBuffer;
                Intrinsics.checkNotNull((Object)byteBuffer2);
                return byteBuffer2.get();
            }
            this.substBuffer = null;
        }
        this.stream.mark(1024);
        int firstVal = this.stream.read();
        if (firstVal == -1) {
            return firstVal;
        }
        char firstChar = (char)firstVal;
        if (firstChar != '%') {
            return firstVal;
        }
        int secondVal = this.stream.read();
        if (secondVal == -1 || (char)secondVal != '%' || this.skipNext) {
            if (this.skipNext && (char)secondVal == '%') {
                this.skipNext = false;
            }
            this.stream.reset();
            return this.stream.read();
        }
        StringBuilder prop = new StringBuilder();
        prop.append("%%");
        while (true) {
            int firstSubstVal;
            if ((firstSubstVal = this.stream.read()) == -1) {
                this.stream.reset();
                return this.stream.read();
            }
            char firstSubstChar = (char)firstSubstVal;
            if (firstSubstChar != '%') {
                prop.append(firstSubstChar);
                continue;
            }
            int secondSubstVal = this.stream.read();
            if (secondSubstVal == -1) {
                this.stream.reset();
                return this.stream.read();
            }
            char secondSubstChar = (char)secondSubstVal;
            if (secondSubstChar == '%') break;
            prop.append(firstSubstChar);
            prop.append(secondSubstChar);
        }
        prop.append("%%");
        String string = prop.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String substName = string;
        String substValue = this.subs.getProperty(substName);
        if (substValue == null) {
            this.warnings.add("No value for " + substName);
            this.stream.reset();
            this.skipNext = true;
            return this.stream.read();
        }
        if (((CharSequence)substValue).length() == 0) {
            return this.stream.read();
        }
        String string2 = substValue;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        ByteBuffer byteBuffer = this.substBuffer = ByteBuffer.wrap(byArray);
        Intrinsics.checkNotNull((Object)byteBuffer);
        return byteBuffer.get();
    }

    @Override
    public int read(@NotNull byte[] b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) {
        int nextByte;
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        int written = 0;
        for (int rem = len; 0 < rem && (nextByte = this.read()) != -1; --rem) {
            b[off + written++] = (byte)nextByte;
        }
        return written;
    }

    @Override
    public int available() {
        return this.stream.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() {
        this.stream.close();
    }

    @Override
    @NotNull
    public byte[] readAllBytes() {
        int nextByte;
        List bytes = new ArrayList();
        while ((nextByte = this.read()) != -1) {
            bytes.add((byte)nextByte);
        }
        return CollectionsKt.toByteArray((Collection)bytes);
    }

    public final boolean hasWarnings() {
        return !((Collection)this.warnings).isEmpty();
    }
}

